package com.agilex.healthcare.veteranappointment.datalayer.feedback;

import javax.annotation.Resource;

import org.apache.commons.beanutils.BeanUtils;
import org.springframework.stereotype.Service;

import com.agilex.healthcare.veteranappointment.domain.VARFeedback;

@Service
public class UserFeedbackDataLayerRepo implements UserFeedbackDataLayer{

	@Resource
	private UserFeedbackDao dao;

	@Override
	public VARFeedback saveUserFeedback(VARFeedback userFeedback) {
		if(userFeedback == null){
			return null;
		}
		UserFeedbackPo userFeedbackPo = toPo(userFeedback); 
		return toDto(dao.saveUserFeedback(userFeedbackPo));
	}

	private VARFeedback toDto(UserFeedbackPo po) {
		VARFeedback dto = new VARFeedback();
		copyProperties(dto, po);
		return dto;
	}

	private UserFeedbackPo toPo(VARFeedback dto) {
		UserFeedbackPo po = new UserFeedbackPo();
		copyProperties(po, dto);
		return po;
	}

	private void copyProperties(Object dest, Object origin){
		try {
			BeanUtils.copyProperties(dest, origin);
		} catch (Exception e) {
			throw new RuntimeException("Unable to copy properties");
		}
	}
}
